import sys
import math
import bisect

def solve():
    input = sys.stdin.read().split()
    ptr = 0
    n = int(input[ptr]); ptr += 1
    
    xs = list(map(int, input[ptr:ptr+n])); ptr += n
    hs = list(map(int, input[ptr:ptr+n])); ptr += n
    
    # ??? ?? ?????? ?????????
    best = [float('inf')] * n
    
    # === 1. ???????? ?? ????????? ===
    # ???????? ??????? ?? x ??????????
    masts_by_x = sorted([(xs[i], hs[i], i) for i in range(n)], key=lambda x: x[0])
    xs_sorted = [m[0] for m in masts_by_x]
    
    # ???????? ??????? ?? ?????? (?????????)
    masts_by_h = sorted([(hs[i], xs[i], i) for i in range(n)], key=lambda x: -x[0])
    
    # ???? ???????? (???????) ??????? - ????????? ???????? ?? x
    active_x = []
    active_data = []
    
    for h_i, x_i, idx_i in masts_by_h:
        # ??????????? ???????? ? ???????? ?????????
        pos = bisect.bisect_left(active_x, x_i)
        
        # ??????????? ???? ?????? ?????? (?????????? ???? ???? ? ??????)
        start = max(0, pos - 8)
        end = min(len(active_x), pos + 9)
        
        for j in range(start, end):
            x_j, h_j, idx_j = active_data[j]
            # ??????? ?????????
            dx = x_i - x_j
            dy = h_i - h_j
            dist = math.sqrt(dx*dx + dy*dy)
            if dist < best[idx_i]:
                best[idx_i] = dist
        
        # ????? ???? ?????? ? ???????
        active_x.insert(pos, x_i)
        active_data.insert(pos, (x_i, h_i, idx_i))
    
    # === 2. ???????? ?? ???????? ===
    # ?? ????? ????? ?????? j ? j+1 ? ??????????? ????
    for j in range(n-1):
        x1, h1 = xs[j], hs[j]
        x2, h2 = xs[j+1], hs[j+1]
        
        # ?????????? ????? ??????? ??????
        x0 = (h1 + x1 - h2 + x2) / 2.0
        y0 = -x0 + (h1 + x1)
        
        # ??????????? ??? ??????? ???? ?? ????? ? x ??????????
        # ????????? ????????? ??? ?? ???? ?????? ?????????
        left_bound = min(x1, x2, x0) - 1000  # ????????? ??????
        right_bound = max(x1, x2, x0) + 1000
        
        left_pos = bisect.bisect_left(xs_sorted, left_bound)
        right_pos = bisect.bisect_right(xs_sorted, right_bound)
        
        for pos in range(left_pos, right_pos):
            x_i, h_i, idx_i = masts_by_x[pos]
            
            if max(h1, h2) < h_i:
                continue
            
            # ??????? ???? ??????
            if y0 >= h_i:
                dx = x_i - x0
                dy = h_i - y0
                dist = math.sqrt(dx*dx + dy*dy)
                if dist < best[idx_i]:
                    best[idx_i] = dist
            
            # ??????? ???? ????? ? ?????? h_i
            if h1 >= h_i:
                x_left = (h1 + x1) - h_i
                if x1 <= x_left <= x0:
                    dist = abs(x_i - x_left)
                    if dist < best[idx_i]:
                        best[idx_i] = dist
            
            # ??????? ????? ????? ? ?????? h_i
            if h2 >= h_i:
                x_right = h_i - (h2 - x2)
                if x0 <= x_right <= x2:
                    dist = abs(x_i - x_right)
                    if dist < best[idx_i]:
                        best[idx_i] = dist
    
    # === 3. ????? ????????? ===
    out_lines = []
    for i in range(n):
        if best[i] == float('inf'):
            out_lines.append("-1")
        else:
            # ???????????? ?? ???????? ??? ????
            out_lines.append(str(int(round(best[i]))))
    
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    solve()